/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWAssignmentInstructionTableModel;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWFieldNameCellEditor;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWAssignmentParamPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWTableActionListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private boolean m_firstTime = true;
    protected VWToolbarBorder m_assignmentBorder = null;
    protected VWAssignmentInstructionTableModel m_assignmentTableModel = null;
    protected VWTable m_assignmentTable = null;
    private GridBagConstraints m_gbCons = null;

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initControls();
        this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        this.m_assignmentTable.stopEditing();
        this.m_assignmentTable.setEnabled(instructionDef != null);
        this.m_assignmentTableModel.setInstructionDefinition(instructionDef);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_firstTime) {
            this.m_firstTime = false;
            if (this.m_assignmentTable != null) {
                this.m_assignmentTable.fitColumnsInTable();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_assignmentTable.stopEditing();
            if (event.getSource() == this.m_assignmentBorder) {
                switch (event.getID()) {
                    case 0x10000000: {
                        int nRowIndex = this.m_assignmentTable.getSelectedRow();
                        this.m_assignmentTableModel.deleteItem(nRowIndex);
                        break;
                    }
                    case 1: {
                        this.onUp();
                        break;
                    }
                    case 2: {
                        this.onDown();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_assignmentTable.getSelectedRow()) {
                    this.m_assignmentTable.clearSelection();
                }
                this.m_assignmentTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_assignmentBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_assignmentBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_assignmentTable.getSelectedRow();
            if (this.m_assignmentTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_assignmentTableModel.getRowCount()) - 1) {
                this.m_assignmentBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_assignmentBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                if (nRowIndex == 0) {
                    this.m_assignmentBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_assignmentBorder.getClientPanel(), 2, 1));
                }
                if (nRowIndex == nRowCount - 1) {
                    this.m_assignmentBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_assignmentBorder.getClientPanel(), 2, 2));
                }
                if (nRowCount == 1) {
                    this.m_assignmentBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_assignmentBorder.getClientPanel(), 2, 0x10000000));
                }
            }
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_assignmentTable == null) break;
                this.m_assignmentTable.stopEditing();
            }
        }
    }

    protected void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_assignmentBorder = new VWToolbarBorder(VWResource.s_assignmentParametersStr, 0x10000003);
        this.m_assignmentBorder.addToolbarBorderActionNotifier(this);
        this.add((Component)this.m_assignmentBorder, this.m_gbCons);
        JPanel panel = this.m_assignmentBorder.getClientPanel();
        panel.setLayout(new GridLayout());
        this.m_assignmentTableModel = new VWAssignmentInstructionTableModel(this.m_authPropertyData, null);
        this.m_assignmentTableModel.addTableModelListener(this);
        this.m_assignmentTable = new VWTable(this.m_assignmentTableModel);
        this.m_assignmentTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_assignmentTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_assignmentTable.setRowSelectionAllowed(true);
        this.m_assignmentTable.getSelectionModel().addListSelectionListener(this);
        this.m_assignmentTable.getSelectionModel().setSelectionMode(0);
        TableColumn tcElement = this.m_assignmentTable.getColumnModel().getColumn(0);
        if (tcElement != null) {
            tcElement.setCellEditor(new VWFieldNameCellEditor(this.m_authPropertyData));
        }
        if ((tcElement = this.m_assignmentTable.getColumnModel().getColumn(1)) != null) {
            tcElement.setCellEditor(new VWExpressionCellEditor(this.m_authPropertyData));
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        panel.add(new JScrollPane(this.m_assignmentTable));
    }

    protected void onUp() {
        try {
            int nRowIndex = this.m_assignmentTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_assignmentTableModel.up(nRowIndex);
                this.m_assignmentTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onDown() {
        try {
            int nRowIndex = this.m_assignmentTable.getSelectedRow();
            if (nRowIndex < this.m_assignmentTableModel.getRowCount() - 2) {
                this.m_assignmentTableModel.down(nRowIndex);
                this.m_assignmentTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

